	page	60,132

;**********************************************************************
;								      *	
;	Stanford Research Systems RS232 Drivers v.1.1		      *	
;								      *	
;	Andrew Mendelsohn, 1/27/80				      *	
;								      *	
;**********************************************************************	



extrn	_nocom:far

data	segment	public	'data'

data	ends

dgroup	group	data


code	segment	'code'
	assume	cs:code,ds:dgroup,ss:dgroup


status	equ	3fdh		;UART status port address
modcon	equ	3fch		;modem status reg
rxdata	equ	3f8h		;UART data port address
linctl	equ	3fbh		;UART  line control register
divreg	equ	3f9h		;UART divisor register

keybrd	equ	16h		;Int for rom bios call for keyboard
rs232	equ	14h 		;Int for rom bios service of rs232
cr	equ	0dh		;carriage return
lf	equ	0ah		;line feed


public  _init
_init 	proc	far

	push	bp		;save the frame pointer
	mov	bp,sp		;get the pointer to the function code
	push	si
	push	di

	mov	ah,0		;initialize request
	mov	dx,0		;point to the first card
	mov	al,11100111b	;9600 baud, no parity, 2 stop bits
 	int	rs232		;off to rom bios

;	now set 19.2 Kbaud operation

	mov	dx,linctl	;point to line control register
	in	al,dx		;get it
	mov	ah,al		;save it

	or	al,10000000b	;turn on divisor access bit
	out	dx,al
	mov	dx,divreg	;point to msb of divisor
	sub	al,al		;this is 0
	out	dx,al
	mov	al,6h		;19.2 kbaud
	dec	dx		;point to lsb of divisor
	out	dx,al

	mov	dx,linctl	;point to line control reg
	mov	al,ah		;restore divisor latch to 0
	out	dx,al

;	end of 19.2 set

	mov	al,00000111b	;set clear to send
	mov	dx,modcon	;modem control reg
	out	dx,al	

	mov	dx,status	;point to the status port
	in 	al,dx		;clear errors
	mov	dx,rxdata	;point to data port
	in	al,dx		;clear pending data

	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret

_init	endp

public  _txstr
_txstr	proc	far

	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds

send:	lds	si,dword ptr [bp+6]	;point to the first character to go
	sub	cx,cx			;will flag end of string when <>0

	cld
gtnxt:	lodsb			;get the character
	mov	ah,al		;save it
	cmp	al,'$'		;test for end of string
	jnz	nlast		;jump if at end of string

	mov	ah,cr
	mov	cx,1
	jmp	short xhold1

nlast:	cmp	al,' '		;check for a superflous blank
	jz	short gtnxt
	
xhold1:	mov	dx,status	;get transmitter status
	in	al,dx		;get status
	test	al,20h
	jz	xhold1		;if not ready wait

	mov	dx,rxdata	;output the character
	mov	al,ah
	out	dx,al

	jcxz	short gtnxt

	pop	ds
	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret

_txstr	endp


public	_rxstr
_rxstr	proc	far

	push	bp
	mov	bp,sp
	push	si
	push	di


	les	di,dword ptr [bp+6] ;point to the start of the string

;	get the character

	mov	cx,15		;counter for blanks
	mov	bx,0ffffh	;counter for timout loop
	cld

statlp:	mov	dx,status	;point to the status port
	dec	bx
	jz	timout

	in	al,dx		;get the status byte
	test	al,1 		;check for rececived data
	jz	statlp		;wait for data

	mov	dx,rxdata	;point to the data port
	in	al,dx		;get the data byte

	stosb			;place the character in the string
	dec	cx		;decrement number of blanks to place

	cmp	al,0dh		;was it a <cr>?
	jnz 	statlp 		;go back for more characters

	dec	di
	mov	al,' '		;clear remainder of buffer
rep	stosb			;fill with spaces

	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret

timout:	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	call 	_nocom
	ret

_rxstr 	endp


code	ends
	end


